% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MG1363}
\alias{MG1363}
\alias{MG1363_PreSaved_DataMapObj}
\alias{MG1363_PreSaved_ResultsObj_GenBank}
\alias{MG1363_PreSaved_ResultsObj_GeneMarkS2}
\alias{MG1363_PreSaved_ResultsObj_Glimmer}
\alias{MG1363_PreSaved_ResultsObj_Prodigal}
\title{\code{Assessment} Objects for
\emph{Lactococcus lactis} subsp. \emph{cremoris} strain MG1363}
\format{All 5 objects have a list structure. For specifics on what the two
types of \code{Assessment} objects contain, please see the \pkg{AssessORF}
package.}
\source{
Proteomcis data: \url{http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD011263}

NCBI's Genome Browser: \url{https://www.ncbi.nlm.nih.gov/genome/browse/#!/prokaryotes/}

GenBank record: \url{https://www.ncbi.nlm.nih.gov/nuccore/AM406671.1}
}
\usage{
data(MG1363_PreSaved_DataMapObj)
data(MG1363_PreSaved_ResultsObj_GenBank)
data(MG1363_PreSaved_ResultsObj_GeneMarkS2)
data(MG1363_PreSaved_ResultsObj_Glimmer)
data(MG1363_PreSaved_ResultsObj_Prodigal)
}
\description{
Objects of class \code{Assessment} and either
subclass \code{DataMap} or subclass \code{Results} for
\emph{Lactococcus lactis} subsp. \emph{cremoris} strain MG1363
}
\details{
'MG1363_PreSaved_DataMapObj' is an object of subclass \code{DataMap}.

'MG1363_PreSaved_ResultsObj_GenBank' is an object of subclass
\code{Results} with predicted genes from the GenBank database.

'MG1363_PreSaved_ResultsObj_GeneMarkS2' is an object of subclass
\code{Results} with predicted genes from the program GeneMarkS-2.

'MG1363_PreSaved_ResultsObj_Glimmer' is an object of subclass
\code{Results} with predicted genes from the program Glimmer.

'MG1363_PreSaved_ResultsObj_Prodigal' is an object of subclass
\code{Results} with predicted genes from the program Prodigal.

For all 5 objects, values of two key identifying list items within
each object are listed below.
\itemize{
\item \code{StrainID}: MG1363
\item \code{Species}: L. lactis
}
}
\section{Mapping object}{

The mapping object, 'MG1363_PreSaved_DataMapObj', stores the mapping of
proteomics evidence and evolutionary conservation evidence to the strain's
genome. The raw proteomics mass spectra data came from  ProteomeXchange
dataset PXD011263. The related genomes used to determine evolutionary
conservation all came from the family, Streptococcaceae exculding anomalous
genomes and non-complete \emph{Streptococcus pneumoniae} genomes. Links to
their sequences were downloaded from NCBI's Genome Browser. The object was
built using the \code{MapAssessmentData} function from the \pkg{AssessORF}
package.
}

\section{Results objects}{

The 4 results objects, 'MG1363_PreSaved_ResultsObj_GenBank',
'MG1363_PreSaved_ResultsObj_GeneMarkS2',
'MG1363_PreSaved_ResultsObj_Glimmer', and
'MG1363_PreSaved_ResultsObj_Prodigal', store how much evidence there is
supporting or against each gene in a set of predicted genes for the strain's
genome. The four objects were built using the \code{AssessGenes} function
from the \pkg{AssessORF} package, a set of genes, and the mapping object
described here.

For the GenBank object, the genes were downloaded from the
corresponding record in the GenBank database. For the other three objects,
GenemarkS-2 (web server), Prodigal (2.6.3), and Glimmer (3.02) were run at
default settings in order to generate the set of predicted genes for the
corresponding results object.

The \code{GeneLeftPos}, \code{GeneRightPos}, and the \code{GeneStrand}
within each of the four results objects provide positional information on
the set of predicted genes used to generate that object.

The \code{GeneSource} list item within each of the four results objects
describes where the predicted genes came from (either "GenBank",
"GeneMarkS2", "Glimmer", or "Prodigal" respectively).
}

\section{Getting the strain's genome}{

Use \code{SaveGenomeToPath("MG1363", <INSERT FILE PATH HERE>)} to save
the genome sequence for the strain to your local machine.
}

