% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{weightedSd}
\alias{weightedSd}
\alias{weightedSd,Zi-method}
\alias{weightedVar}
\alias{weightedVar,Zi-method}
\title{Weighted Variance and weighted Standard Deviation}
\usage{
weightedSd(x, w = NULL, idxs = NULL, na.rm = FALSE, center = NULL, ...)

weightedVar(x, w = NULL, idxs = NULL, na.rm = FALSE, center = NULL, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{Zi}}-class object}

\item{w}{a numerical \code{\link[base]{vector}} of weight the same length as
x giving the weights to use for elements of x}

\item{idxs}{A \code{\link[base]{vector}} indicating subset of elements to
operate over. If \code{\link{NULL}}, no subsetting is done.}

\item{na.rm}{\code{\link[base]{logical}} If \code{\link{TRUE}}
\code{\link{NA}}s are excluded, otherwise not. default = \code{\link{FALSE}}}

\item{center}{\code{\link{numeric}} scalar specifying the center location of
the data. If \code{\link{NULL}}, it is estimated from data.}

\item{...}{\code{\link[matrixStats]{weightedVar}}}
}
\value{
a \code{\link{numeric}} scalar
}
\description{
Calculate a weighted variance and standard deviation of zero
inflated count data, additionally taking weights for structural zeros into
account
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
weight <- runif(length(inputcounts(Zi)), 0.1, 1)
weightedVar(Zi, w= weight)
weightedSd(Zi, w = weight)
}
\seealso{
\link[matrixStats]{weightedVar}, \link[zitools]{rowWeightedVars},
\link[zitools]{colWeightedVars}
}
