% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{tax_table}
\alias{tax_table}
\alias{tax_table,Zi-method}
\title{Access the taxonomy table}
\usage{
\S4method{tax_table}{Zi}(object)
}
\arguments{
\item{object}{\code{\linkS4class{Zi}}-class object}
}
\value{
tax_table
}
\description{
access the taxonomy table (\link[phyloseq]{tax_table}) of an
\code{\linkS4class{Zi}}-class object if the inputdata slot is a phyloseq
object
}
\examples{
data(mtx)
OTU <- otu_table(mtx, taxa_are_rows = TRUE)
sample_data <- data.frame(SampleID = c('Sample1', 'Sample2', 'Sample3',
    'Sample4', 'Sample5', 'Sample6', 'Sample7', 'Sample8', 'Sample9',
    'Sample10'),
    Group = factor(x = c(1,1,1,1,1,2,2,2,2,2)))
SAM <- sample_data(sample_data)
tax_table <- data.frame(Kingdom = c(rep('Bacteria', times = 100)),
    Phylum = c(rep('Bacteroidetes', times = 50),
    rep('Firmicutes', times = 50)))
TAX <- tax_table(tax_table)
ps <- phyloseq::phyloseq(OTU, TAX, SAM)
Zi <- ziMain(ps)
tax_table(Zi)

}
