% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{subset_feature}
\alias{subset_feature}
\title{Subset a \code{\linkS4class{Zi}}-class object based on feature data}
\usage{
subset_feature(Zi, ...)
}
\arguments{
\item{Zi}{\code{\linkS4class{Zi}}-class object}

\item{...}{The subsetting expression that should be applied, see
\link[base]{subset} for more details}
}
\value{
a \code{\linkS4class{Zi}}-class object after subsetting is done
}
\description{
Subset a \code{\linkS4class{Zi}}-class object based on tax_table
of a phyloseq
object or on rowData of a SummarizedExperiment object
}
\examples{
data(mtx)
OTU <- otu_table(mtx, taxa_are_rows = TRUE)
sample_data <- data.frame(SampleID = c('Sample1', 'Sample2', 'Sample3',
    'Sample4', 'Sample5', 'Sample6', 'Sample7', 'Sample8', 'Sample9',
    'Sample10'),
    Group = factor(x = c(1,1,1,1,1,2,2,2,2,2)))
SAM <- sample_data(sample_data)
tax_table <- data.frame(Kingdom = c(rep('Bacteria', times = 100)),
    Phylum = c(rep('Bacteroidetes', times = 50),
    rep('Firmicutes', times = 50)))
TAX <- tax_table(tax_table)
ps <- phyloseq::phyloseq(OTU, TAX, SAM)
Zi <- ziMain(ps)
subset_Zi_phylo <- subset_feature(Zi, ta2 == 'Bacteroidetes')
}
