% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_fit.R
\name{zinb.regression.parseModel}
\alias{zinb.regression.parseModel}
\title{Parse ZINB regression model}
\usage{
zinb.regression.parseModel(alpha, A.mu, B.mu, C.mu, A.pi, B.pi, C.pi)
}
\arguments{
\item{alpha}{the vectors of parameters c(a.mu, a.pi, b) concatenated}

\item{A.mu}{matrix of the model (see above, default=empty)}

\item{B.mu}{matrix of the model (see above, default=empty)}

\item{C.mu}{matrix of the model (see above, default=zero)}

\item{A.pi}{matrix of the model (see above, default=empty)}

\item{B.pi}{matrix of the model (see above, default=empty)}

\item{C.pi}{matrix of the model (see above, default=zero)}
}
\value{
A list with slots \code{logMu}, \code{logitPi}, \code{dim.alpha} (a
  vector of length 3 with the dimension of each of the vectors \code{a.mu},
  \code{a.pi} and \code{b} in \code{alpha}), and \code{start.alpha} (a vector
  of length 3 with the starting indices of the 3 vectors in \code{alpha})
}
\description{
Given the parameters of a ZINB regression model, this function parses the
model and computes the vector of log(mu), logit(pi), and the dimensions of
the different components of the vector of parameters. See
\code{\link{zinb.loglik.regression}} for details of the ZINB regression model
and its parameters.
}
\seealso{
\code{\link{zinb.loglik.regression}}
}
