% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_fit.R
\name{zinb.loglik.regression.gradient}
\alias{zinb.loglik.regression.gradient}
\title{Gradient of the penalized log-likelihood of the ZINB regression model}
\usage{
zinb.loglik.regression.gradient(
  alpha,
  Y,
  A.mu = matrix(nrow = length(Y), ncol = 0),
  B.mu = matrix(nrow = length(Y), ncol = 0),
  C.mu = matrix(0, nrow = length(Y), ncol = 1),
  A.pi = matrix(nrow = length(Y), ncol = 0),
  B.pi = matrix(nrow = length(Y), ncol = 0),
  C.pi = matrix(0, nrow = length(Y), ncol = 1),
  C.theta = matrix(0, nrow = length(Y), ncol = 1),
  epsilon = 0
)
}
\arguments{
\item{alpha}{the vectors of parameters c(a.mu, a.pi, b) concatenated}

\item{Y}{the vector of counts}

\item{A.mu}{matrix of the model (see Details, default=empty)}

\item{B.mu}{matrix of the model (see Details, default=empty)}

\item{C.mu}{matrix of the model (see Details, default=zero)}

\item{A.pi}{matrix of the model (see Details, default=empty)}

\item{B.pi}{matrix of the model (see Details, default=empty)}

\item{C.pi}{matrix of the model (see Details, default=zero)}

\item{C.theta}{matrix of the model (see Details, default=zero)}

\item{epsilon}{regularization parameter. A vector of the same length as
\code{alpha} if each coordinate of \code{alpha} has a specific
regularization, or just a scalar is the regularization is the same for all
coordinates of \code{alpha}. Default=\code{O}.}
}
\value{
The gradient of the penalized log-likelihood.
}
\description{
This function computes the gradient of the penalized log-likelihood of a ZINB
regression model given a vector of counts.
}
\details{
The regression model is described in
  \code{\link{zinb.loglik.regression}}.
}
\seealso{
\code{\link{zinb.loglik.regression}}
}
