% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detest.R
\name{pvalueAdjustment}
\alias{pvalueAdjustment}
\title{Perform independent filtering in differential expression analysis.}
\usage{
pvalueAdjustment(
  baseMean,
  filter,
  pValue,
  theta,
  alpha = 0.05,
  pAdjustMethod = "BH"
)
}
\arguments{
\item{baseMean}{A vector of mean values.}

\item{filter}{A vector of stage-one filter statistics.}

\item{pValue}{A vector of unadjusted p-values, or a function which
is able to compute this vector from the filtered portion of data,
if data is supplied. The option to supply a function is useful when
the value of the test statistic depends on which hypotheses are
filtered out at stage one. (The limma t-statistic is an example.)}

\item{theta}{A vector with one or more filtering fractions to
consider. Actual cutoffs are then computed internally by applying
quantile to the filter statistics contained in (or produced by)
the filter argument.}

\item{alpha}{A cutoff to which p-values, possibly adjusted for
multiple testing, will be compared. Default is 0.05.}

\item{pAdjustMethod}{The unadjusted p-values contained in
(or produced by) test will be adjusted for multiple testing after
filtering. Default is "BH".}
}
\value{
a list with pvalues, filtering threshold, theta,
number of rejections, and alpha.
}
\description{
This function performs independent filtering to increase detection
power in high throughput gene expression studies.
}
\note{
This function is an adapted version of the
\code{pvalueAdjustment} function that was originally written by
Michael I. Love as part of the DESeq2 package.
Koen Van den Berge adapted the function.
}
