% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDensity.R
\name{plotDensity}
\alias{plotDensity}
\title{Density plots of columns in a matrix}
\usage{
plotDensity(obj, groups = NULL, normalized = FALSE, legendPos = NULL,
  ...)
}
\arguments{
\item{obj}{ExpressionSet object}

\item{groups}{Vector of labels for each sample or a column name of the phenoData slot
for the ids to filter. Default is the column names.}

\item{normalized}{TRUE / FALSE, use the normalized matrix or log2-transformed raw counts}

\item{legendPos}{Legend title position. If null, does not create legend by default.}

\item{...}{Extra parameters for \link[quantro]{matdensity}.}
}
\value{
A density plot for each column in the ExpressionSet object colored by groups
}
\description{
Plots the density of the columns of a matrix. Wrapper for \code{\link[quantro]{matdensity}}.
}
\examples{
data(skin)
filtData <- filterLowGenes(skin,"SMTSD")
plotDensity(filtData,groups="SMTSD",legendPos="topleft")
# to remove the legend
plotDensity(filtData,groups="SMTSD")

}
