% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMisAnnotation.R
\name{checkMisAnnotation}
\alias{checkMisAnnotation}
\title{Check for wrong annotation of a sample using classical MDS and control genes.}
\usage{
checkMisAnnotation(obj, phenotype, controlGenes = "all",
  columnID = "chromosome_name", plotFlag = TRUE,
  legendPosition = NULL, ...)
}
\arguments{
\item{obj}{ExpressionSet object.}

\item{phenotype}{phenotype column name in the phenoData slot to check.}

\item{controlGenes}{Name of controlGenes, ie. 'Y' chromosome. Can specify 'all'.}

\item{columnID}{Column name where controlGenes is defined in the featureData slot if other than 'all'.}

\item{plotFlag}{TRUE/FALSE Whether to plot or not}

\item{legendPosition}{Location for the legend.}

\item{...}{Extra parameters for \code{\link{plotCMDS}} function.}
}
\value{
Plots a classical multi-dimensional scaling of the 'controlGenes'. Optionally returns co-ordinates.
}
\description{
Check for wrong annotation of a sample using classical MDS and control genes.
}
\examples{
data(bladder)
checkMisAnnotation(bladder,'GENDER',controlGenes='Y',legendPosition='topleft')

}
