% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_mtif.R
\name{cacheMtif}
\alias{cacheMtif}
\title{cache and/or retrieve path to an ome.tif file for demonstration}
\usage{
cacheMtif(
  cache = BiocFileCache::BiocFileCache(),
  url =
    "https://mghp.osn.xsede.org/bir190004-bucket01/BiocXenData/morphology_focus_0001.ome.tif"
)
}
\arguments{
\item{cache}{defaults to BiocFileCache::BiocFileCache()}

\item{url}{location where tiff file can be retrieved}
}
\value{
path to cached resource
}
\description{
cache and/or retrieve path to an ome.tif file for demonstration
}
\note{
The tiff file was retrieved after running SFEData::XeniumOutput("v2"),
and depicts a pancreas tissue sample.
}
\examples{
pa <- cacheMtif()
if (!requireNamespace("tiff")) stop("install tiff package to run this example")
x <- tiff::readTIFF(pa)
plot(0, xlim = c(0, 1000), ylim = c(0, 1000), xlab = " ", ylab = " ")
rasterImage(x * 5.5, 0, 0, 1000, 1000)
}
