% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{repVarianceWeightedAvgZscore}
\alias{repVarianceWeightedAvgZscore}
\title{Calculate replicate variance weighted averaged Z-scores}
\usage{
repVarianceWeightedAvgZscore(pvalues, groups)
}
\arguments{
\item{pvalues}{Data frame with \code{'se'} (standard error) and \code{'coef'}
(coefficient) columns. Such as in \code{pvalues} output of
\code{modelGeneExpression} .}

\item{groups}{Factor giving group membership for samples in  \code{pvalues}.}
}
\value{
Numeric matrix of averaged Z-scores. Columns correspond to groups and
rows to predictors.
}
\description{
Replicate averaged Z-scores is calculated by dividing replicate average
coefficient by replicate pooled standard error.
}
