% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{modelGeneExpression_ridge_regression_wraper}
\alias{modelGeneExpression_ridge_regression_wraper}
\title{Ridge regression wrapper for modelGeneExpression}
\usage{
modelGeneExpression_ridge_regression_wraper(
  mae,
  yname,
  uname,
  xnames,
  groups,
  standardize,
  parallel,
  precalcmodels,
  ...
)
}
\arguments{
\item{mae}{MultiAssayExperiment object such as produced by
\code{\link{prepareCountsForRegression}}.}

\item{yname}{string indicating experiment in \code{mae} to use as the
expression input.}

\item{uname}{string indicating experiment in \code{mae} to use as the basal
expression level.}

\item{xnames}{character indicating experiments in \code{mae} to use as
molecular signatures.}

\item{groups}{factor representation of design matrix.}

\item{standardize}{logical flag indicating if the molecular signatures should
be scaled. Advised to be set to \code{TRUE}.}

\item{parallel}{parallel argument to internally used
\code{\link[glmnet]{cv.glmnet}} function. Advised to be set to \code{FALSE}
as it might interfere with parallelization used in \code{modelGeneExpression}.}

\item{precalcmodels}{optional list of precomputed \code{'cv.glmnet'} objects
for each molecular signature and sample. The elements of this list should
be matching the \code{xnames} vector. Each of those elements should be a
named list holding \code{'cv.glmnet'} objects for each sample. If provided
those models will be used instead of running regression from scratch.}

\item{...}{arguments passed to glmnet::cv.glmnet.}
}
\value{
Named list with elements corresponding to signatures specified in
\code{xnames}. Each of these is a list holding \code{'cv.glmnet'} objects
corresponding to each sample.
}
\description{
Internal function used in \code{modelGeneExpression}. It runs ridge regression
parallelly across signatures and samples as specified by experiment design.
}
