% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{fisherMethod}
\alias{fisherMethod}
\title{Combine p-values using Fisher method}
\usage{
fisherMethod(p.value, lower.tail = FALSE, log.p = TRUE)
}
\arguments{
\item{p.value}{a numeric vector of p-values to combine.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
a number giving combined p-value.
}
\description{
Fisher's method is a meta-analysis technique used to combine the results from
independent statistical tests with the same hypothesis
(\href{https://en.wikipedia.org/wiki/Fisher\%27s_method}{Wikipedia article}).
}
