% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-XCMSnExp.R
\name{writeMSData,XCMSnExp,character-method}
\alias{writeMSData,XCMSnExp,character-method}
\title{Export MS data to mzML/mzXML files}
\usage{
\S4method{writeMSData}{XCMSnExp,character}(
  object,
  file,
  outformat = c("mzml", "mzxml"),
  copy = FALSE,
  software_processing = NULL,
  ...
)
}
\arguments{
\item{object}{\link{XCMSnExp} object with the mass spectrometry data.}

\item{file}{\code{character} with the file name(s). The length of this parameter
has to match the number of files/samples of \code{object}.}

\item{outformat}{\code{character(1)} defining the format of the output files (
either \code{"mzml"} or \code{"mzxml"}).}

\item{copy}{\code{logical(1)} if metadata (data processing, software used,
original file names etc) should be copied from the original files.}

\item{software_processing}{optionally provide specific data processing steps.
See documentation of the \code{software_processing} parameter of
\code{\link[MSnbase:writeMSData]{MSnbase::writeMSData()}}.}

\item{...}{Additional parameters to pass down to the \code{\link[MSnbase:writeMSData]{MSnbase::writeMSData()}}
function in the \code{MSnbase} package, such as \code{outformat} to specify the
output format (\code{"mzml"} or \code{"mzxml"}) or \code{copy} to specify whether
general information from the original MS data files (such as data
processing, software etc) should be copied to the new files.}
}
\description{
\code{writeMSData} exports mass spectrometry data in mzML or mzXML format.
If adjusted retention times are present, these are used as retention time of
the exported spectra.
}
\seealso{
\code{\link[MSnbase:writeMSData]{MSnbase::writeMSData()}} function in the \code{MSnbase} package.
}
\author{
Johannes Rainer
}
