% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_data.R
\name{wppi_go_data}
\alias{wppi_go_data}
\title{Retrieves data from Gene Ontology (GO)}
\usage{
wppi_go_data(slim = NULL, aspects = c("C", "F", "P"), organism = "human")
}
\arguments{
\item{slim}{Character: use a GO subset (slim). If \code{NULL}, the
full GO is used. The most often used slim is called "generic". For
a list of available slims see \code{OmnipathR::go_annot_slim}.}

\item{aspects}{Character vector with the single letter codes of the
gene ontology aspects to use. By default all three aspects are used.
The aspects are "C": cellular component, "F": molecular function and
"P" biological process.}

\item{organism}{Character: name of the organism for GO annotations.}
}
\value{
A data frame (tibble) with GO annotation data.
}
\description{
Gene Ontology (\url{http://geneontology.org/}), GO) annotates genes
by their function, localization and biological processes.
}
\details{
If you use a GO subset (slim), building it at the first time might take
around 20 minutes. The result is saved into the cache so next time loading
the data from there is really quick.
Gene Ontology annotations are available for a few other organisms apart
from human. The currently supported organisms are "chicken", "cow", "dog",
"human", "pig" and "uniprot_all". If you disable \code{HPO_annot} you can
use \code{wppi} to score PPI networks other than human.
}
\examples{
go <- wppi_go_data()

}
\seealso{
\code{\link{wppi_data}}
}
