% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_imports.R
\name{convertESet}
\alias{convertESet}
\title{Convert the phenotype data of an ExpressionSet or MsnSet into a dataframe
for WPM}
\usage{
convertESet(eSet_obj, gp_field = NULL)
}
\arguments{
\item{eSet_obj}{an ExpressionSet/MsnSet object contaning the phenotype data}

\item{gp_field}{character, corresponding to the phenotype data used to
categorize samples into distinct groups if any}
}
\value{
a dataframe containing 3 fields: Sample, Group and ID.
}
\description{
This function converts an ExpressionSet/MsnSet object into a
dataframe to make it usable by the shiny application of wpm as well as by
the wrapper function (version of wpm in command line)
}
\examples{
sample_names <- c("s1","s2","s3","s4", "s5")
M <- matrix(NA, nrow = 4, ncol = 5)
colnames(M) <- sample_names
rownames(M) <- paste0("id", LETTERS[1:4])
pd <- data.frame(Environment = rep_len(LETTERS[1:3], 5),
                 Category = rep_len(1:2, 5), row.names = sample_names)
rownames(pd) <- colnames(M)
x <- MSnbase::MSnSet(exprs = M,pData =  pd)
convertESet(x, "Environment")

}
