% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{well_knotted_spline}
\alias{well_knotted_spline}
\title{Natural cubic spline with good choice of knots}
\usage{
well_knotted_spline(x, n_knots, verbose = TRUE)
}
\arguments{
\item{x}{The predictor variable. A numeric vector.}

\item{n_knots}{Number of knots to use.}

\item{verbose}{If TRUE, produce a message about the knots chosen.}
}
\value{
A matrix of predictors, similar to \code{\link[splines]{ns}}.

This function supports "safe prediction" 
(see \code{\link[stats]{makepredictcall}}). 
Original knot locations will be used for prediction with 
\code{\link[stats]{predict}}.
}
\description{
For use in model formulas, 
natural cubic spline as in \code{splines::ns} 
but with knot positions chosen using
k-means rather than quantiles.
Automatically uses less knots if there are insufficient distinct values.
}
\details{
Wong (1982, 1984) showed the asymptotic density of k-means in 1 dimension is 
    proportional to the cube root of the density of x. 
Compared to using quantiles (the default for \code{\link[splines]{ns}}),
    choosing knots using k-means produces a better spread of knot locations
    if the distribution of values is very uneven.

k-means is computed in an optimal, deterministic way using
\code{\link[Ckmeans.1d.dp]{Ckmeans.1d.dp}}.
}
\examples{
lm(mpg ~ well_knotted_spline(wt,3), data=mtcars)

# When insufficient unique values exist, less knots are used
lm(mpg ~ well_knotted_spline(gear,3), data=mtcars)

library(ggplot2)
ggplot(diamonds, aes(carat, price)) + 
   geom_point() + 
   geom_smooth(method="lm", formula=y~well_knotted_spline(x,10))

}
\references{
Wong, M. (1982).
Asymptotic properties of univariate sample k-means clusters.
Working paper #1341-82, Sloan School of Management, MIT.
\url{https://dspace.mit.edu/handle/1721.1/46876}

Wong, M. (1984). 
Asymptotic properties of univariate sample k-means clusters.
\emph{Journal of Classification}, 1(1), 255–270.
\url{https://doi.org/10.1007/BF01890126}
}
\seealso{
\code{\link[splines]{ns}}, \code{\link[stats]{makepredictcall}}
}
