% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_coord_utils.R
\name{.map_lsap}
\alias{.map_lsap}
\title{Map source spots to best target spots by solving the LSAP}
\usage{
.map_lsap(source_coords, target_coords)
}
\arguments{
\item{source_coords}{A \code{data.frame()} containing the pixel coordinates (i.e.
'pxl_row_in_fullres' and 'pxl_col_in_fullres') of starting spots from one
capture area.}

\item{target_coords}{A \code{data.frame()} containing the pixel coordinates (i.e.
'pxl_row_in_fullres' and 'pxl_col_in_fullres') of target spots which should
just barely encompass the capture area in \code{source_coords}.}
}
\value{
A \link[dplyr:reexports]{tibble} with the same rows as \code{source_coords},
but with the \code{array_row} and \code{array_col} columns (and rounded pixel
coordinates) taken from the best-matching spots in \code{target_coords}.
}
\description{
Given \code{source_coords} and \code{target_coords}, both containing pixel
coordinates of spots, map each spot in \code{source_coords} to a unique
spot in \code{target_coords} such that the total squared Euclidean distance
between matched spots is minimized, with guaranteed one-to-one mapping. This
is done by solving the Linear Sum Assignment Problem (LSAP) using the
Hungarian algorithm. Return the \code{source_coords} with the newly mapped
\code{array_row} and \code{array_col} columns.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
