% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_coord_utils.R
\name{.construct_array}
\alias{.construct_array}
\title{Construct a new Visium-like array encapsulating a set of spots}
\usage{
.construct_array(coords, inter_spot_dist_px, buffer = 1)
}
\arguments{
\item{coords}{A \code{data.frame()} with columns 'pxl_row_in_fullres' and
'pxl_col_in_fullres' whose rows contain spots from potentially multiple
capture areas.}

\item{inter_spot_dist_px}{\code{numeric(1)} vector giving the pixel distance
between any 2 spots in the new coordinates.}

\item{buffer}{\code{numeric(1)} vector giving the number of spot distances
to pad the new array (on all sides) beyond the min/max pixel coordinates in
\code{coords}.}
}
\value{
A \link[dplyr:reexports]{tibble} with columns 'array_row', 'array_col',
'pxl_row_in_fullres', and 'pxl_col_in_fullres', representing the new
Visium-like array.
}
\description{
Given \code{coords} containing pixel coordinates of spots from potentially
multiple capture areas, return a new Visium-like array encapsulating all
such spots.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
