% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsMAMatrix.R
\name{vsMAMatrix}
\alias{vsMAMatrix}
\title{MA plot matrix from \eqn{log_{2}} fold changes and
\eqn{-log_{10}}(\eqn{p}-values)}
\usage{
vsMAMatrix(
  data,
  d.factor = NULL,
  type = c("cuffdiff", "deseq", "edger"),
  padj = 0.05,
  y.lim = NULL,
  lfc = NULL,
  title = TRUE,
  legend = TRUE,
  grid = TRUE,
  counts = TRUE,
  data.return = FALSE,
  xaxis.text.size = 9,
  yaxis.text.size = 9,
  xaxis.title.size = 10,
  yaxis.title.size = 10,
  main.title.size = 15,
  legend.text.size = 9,
  facet.title.size = 10
)
}
\arguments{
\item{data}{output generated from calling the main routines of either
\code{cuffdiff}, \code{DESeq2}, or \code{edgeR} analyses. For
\code{cuffdiff}, this will be a \code{*_exp.diff} file. For \code{DESeq2},
this will be a generated object of class \code{DESeqDataSet}. For
\code{edgeR}, this will be a generated object of class \code{DGEList}.}

\item{d.factor}{a specified factor; for use with \code{DESeq2} objects only.
This input equates to the first parameter for the contrast argument when
invoking the \code{results()} function in \code{DESeq2}. Defaults to
\code{NULL}.}

\item{type}{an analysis classifier to tell the function how to process the
data. Must be either \code{cuffdiff}, \code{deseq}, or \code{edger}.
\code{cuffdiff} must be used with \code{cuffdiff} data; \code{deseq} must
be used for \code{DESeq2} output; \code{edgeR} must be used with
\code{edgeR} data. See the \code{data} parameter for further details.}

\item{padj}{a user defined adjusted \eqn{p}-value cutoff point.
Defaults to \code{0.05}.}

\item{y.lim}{set manual limits (boundaries) to the y axis. Defaults to
\code{NULL}.}

\item{lfc}{\eqn{log} fold change level for setting conditonals. If no user
input is added (\code{NULL}), value defaults to \code{1}.}

\item{title}{display the main title of plot. Logical; defaults to
\code{TRUE}. If set to \code{FALSE}, no title will display in plot.}

\item{legend}{display legend of plot. Logical; defaults to \code{TRUE}.
If set to \code{FALSE}, no legend will display in plot.}

\item{grid}{display major and minor axis lines. Logical; defaults to
\code{TRUE}. If set to \code{FALSE}, no axis lines will display in plot.}

\item{counts}{displays the number of differentially expressed genes for
each treatment comparison. Defaults to \code{TRUE}.}

\item{data.return}{returns data output of plot. Logical; defaults to
\code{FALSE}. If set to \code{TRUE}, a data frame will also be called.
Assign to object for reproduction and saving of data frame. See final
example for further details.}

\item{xaxis.text.size}{change the font size of the \code{x}-axis text.
Defaults to \code{9}.}

\item{yaxis.text.size}{change the font size of the \code{y}-axis text.
Defaults to \code{9}.}

\item{xaxis.title.size}{change the font size of the \code{x}-axis title
text. Defaults to \code{10}.}

\item{yaxis.title.size}{change the font size of the \code{y}-axis title
text. Defaults to \code{10}.}

\item{main.title.size}{change the font size of the plot title text.
Defaults to \code{15}.}

\item{legend.text.size}{change the font size of the legend body text.
Defaults to \code{9}.}

\item{facet.title.size}{change the font size of the facet wrap title text.
Defaults to \code{10}.}
}
\value{
An object created by \code{ggplot}
}
\description{
This function allows you to generate MA plots for all possible treatment
combinations for a given factor in either a cuffdiff, DESeq2, or edgeR
data set.
}
\examples{
# Cuffdiff example
data("df.cuff")
vsMAMatrix(
    data = df.cuff, d.factor = NULL, type = "cuffdiff",
    padj = 0.05, y.lim = NULL, lfc = 1, title = TRUE,
    grid = TRUE, counts = TRUE, data.return = FALSE
)

# DESeq2 example
data("df.deseq")
require(DESeq2)
vsMAMatrix(
    data = df.deseq, d.factor = "condition", type = "deseq",
    padj = 0.05, y.lim = NULL, lfc = 1, title = TRUE,
    grid = TRUE, counts = TRUE, data.return = FALSE
)

# edgeR example
data("df.edger")
require(edgeR)
vsMAMatrix(
    data = df.edger, d.factor = NULL, type = "edger",
    padj = 0.05, y.lim = NULL, lfc = 1, title = TRUE,
    grid = TRUE, counts = TRUE, data.return = FALSE
)

# Extract data frame from visualization
data("df.cuff")
tmp <- vsMAMatrix(
    data = df.cuff, d.factor = NULL,
    type = "cuffdiff", padj = 0.05, y.lim = NULL,
    lfc = 1, title = TRUE, grid = TRUE,
    counts = TRUE, data.return = TRUE
)
df_mamat <- tmp[[1]] ## or use tmp$data
head(df_mamat)

# Show plot from object (see prior example for more details)
tmp[[2]] ## or use tmp$plot
}
\author{
Brandon Monier, \email{brandon.monier@sdstate.edu}
}
