% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcVarPart.R
\docType{methods}
\name{calcVarPart}
\alias{calcVarPart}
\alias{calcVarPart,lm-method}
\alias{calcVarPart,lmerMod-method}
\alias{calcVarPart,glm-method}
\alias{calcVarPart,negbin-method}
\alias{calcVarPart,glmerMod-method}
\alias{calcVarPart,glmer-method}
\title{Compute variance statistics}
\usage{
calcVarPart(fit, returnFractions = TRUE, ...)

\S4method{calcVarPart}{lm}(fit, returnFractions = TRUE, ...)

\S4method{calcVarPart}{lmerMod}(fit, returnFractions = TRUE, ...)

\S4method{calcVarPart}{glm}(fit, returnFractions = TRUE, ...)

\S4method{calcVarPart}{negbin}(fit, returnFractions = TRUE, ...)

\S4method{calcVarPart}{glmerMod}(fit, returnFractions = TRUE, ...)
}
\arguments{
\item{fit}{model fit from lm() or lmer()}

\item{returnFractions}{default: TRUE.  If TRUE return fractions that sum to 1.  Else return unscaled variance components.}

\item{...}{additional arguments (not currently used)}
}
\value{
fraction of variance explained / ICC for each variable in the regression model
}
\description{
Compute fraction of variation attributable to each variable in regression model.  Also interpretable as the intra-class correlation after correcting for all other variables in the model.
}
\details{
For linear model, variance fractions are computed based on the sum of squares explained by each component.  For the linear mixed model, the variance fractions are computed by variance component estimates for random effects and sum of squares for fixed effects.

For a generalized linear model, the variance fraction also includes the contribution of the link function so that fractions are reported on the linear (i.e. link) scale rather than the observed (i.e. response) scale. For linear regression with an identity link, fractions are the same on both scales.  But for logit or probit links, the fractions are not well defined on the observed scale due to the transformation imposed by the link function.

The variance implied by the link function is the variance of the corresponding distribution:

 logit -> logistic distribution -> variance is \eqn{\pi^\frac{2}{3}}

 probit -> standard normal distribution -> variance is 1

For the Poisson distribution with rate \eqn{\lambda}, the variance is \eqn{log(1 + 1/\lambda)}.

For the negative binomial distribution with rate \eqn{\lambda} and shape \eqn{\theta}, the variance is \eqn{log(1 + 1/\lambda + 1/\theta)}.

Variance decomposition is reviewed by Nakagawa and Schielzeth (2012), and expanded to other GLMs by Nakagawa, et al. (2017).  See McKelvey and Zavoina (1975) for early work on applying to GLMs.  Also see DeMaris (2002).

We note that Nagelkerke's pseudo R^2 evaluates the variance explained by the full model.  Instead, a variance partitioning approach evaluates the variance explained by each term in the model, so that the sum of each systematic plus random term sums to 1 (Hoffman and Schadt, 2016; Nakagawa and Schielzeth, 2012).
}
\examples{
library(lme4)
data(varPartData)

# Linear mixed model
fit <- lmer(geneExpr[1, ] ~ (1 | Tissue) + Age, info)
calcVarPart(fit)

# Linear model
# Note that the two models produce slightly different results
# This is expected: they are different statistical estimates
# of the same underlying value
fit <- lm(geneExpr[1, ] ~ Tissue + Age, info)
calcVarPart(fit)

}
\references{
{
  \insertRef{nakagawa2017coefficient}{variancePartition} \cr \cr

  \insertRef{nakagawa2013general}{variancePartition}\cr \cr

  \insertRef{mckelvey1975statistical}{variancePartition}\cr \cr

  \insertRef{demaris2002explained}{variancePartition}\cr \cr

  \insertRef{hoffman2016variancepartition}{variancePartition}\cr \cr
}
}
