% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSORT_GeneSelection.R
\name{driving_force_gene_selection}
\alias{driving_force_gene_selection}
\title{A feature/ gene selection function}
\usage{
driving_force_gene_selection(cds, scattering.cutoff.prob = 0.75,
  driving.force.cutoff = NULL, qval_cutoff = 0.05, min_expr = 0.1,
  data_type = c("linear", "cyclical"), nCores = 1)
}
\arguments{
\item{cds}{a Monocle's CellDataSet object}

\item{scattering.cutoff.prob}{probability used for removing largely dispersed genes}

\item{driving.force.cutoff}{a value used for removing genes which do not change much along cell progress along cell progress path}

\item{qval_cutoff}{a user-defined adjusted p-value below which genes are retained}

\item{min_expr}{the minimum expression value}

\item{data_type}{a character indicating the type of underlying cell progression, i.e. linear or cyclical.}

\item{nCores}{Number of cores to use.}
}
\value{
integer
}
\description{
A feature/ gene selection function (1) removes sparsely expressed genes, (2) identifies
differentially expressed genes based on preliminary cell ordering, (3) removes highly
dispersed genes from the identified DEGs, (4) further picks genes which are expected
to have large expression difference on the 2 extreme ends of preliminary cell ordering
}
\examples{
dir <- system.file('extdata', package='uSORT')
file <- list.files(dir, pattern='.txt$', full=TRUE)
#exprs <- uSORT_preProcess(exprs_file = file)
#exp_raw <- t(exprs$exprs_raw)
#exp_trimmed <- t(exprs$exprs_log_trimed)
#cds <- uSORT:::EXP_to_CellDataSet(exp_trimmed, exp_raw)
#driver_genes <- driving_force_gene_selection(cds = cds)
}
\author{
MaiChan Lau
}

