% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabelClasses.R
\name{relabelClasses}
\alias{relabelClasses}
\title{Re-label clusters.}
\usage{
relabelClasses(droplets, classCol = "class", presentClasses = ddpcr$classes)
}
\arguments{
\item{droplets}{A data frame of droplet amplitudes with a classification.}

\item{classCol}{The column (name or number) from 'droplets' representing
the class.}

\item{presentClasses}{A vector of classes that we want to label. Must be
a subset of c("NN", "NP", "PN", "PP") and must have the same number of
classes as the number of unique classes in the class column.}
}
\value{
The classification column relabelled with "NN", "NP", "PN" and "PP".
}
\description{
An attempt to label clusters with "NN", "NP", "PN" or "PP" automatically.
(This will not generalise to amplitudes in only a single channel.)
}
\examples{
## Look at the "Cluster" column that was created by Bio-Rad's QuantaSoft.
aWell <- KRASdata[["E03"]]
str(aWell$Cluster)

## Relabel the classes to see the difference.
relabelled <- relabelClasses(aWell, classCol="Cluster")
str(relabelled)
levels(relabelled)

## We choose a sample with 3 clusters.
unique(KRASdata[["H04"]]$Cluster)

## We can check that there is no "PP" class, so specify the others only.
relabelled <- relabelClasses(KRASdata[["H04"]], classCol="Cluster",
                             presentClasses=c("NN", "PN", "NP"))
table(relabelled)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
