% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_emb_circle_scale.R
\name{plot_emb_circle_scale}
\alias{plot_emb_circle_scale}
\title{Plot embedding with cyclic cell cycle position}
\usage{
plot_emb_circle_scale(
  sce.o,
  color_by = "tricyclePosition",
  facet_by = NULL,
  dimred = 1,
  dim = seq_len(2),
  fig.title = NULL,
  point.size = 2.1,
  point.alpha = 0.6,
  x_lab = NULL,
  y_lab = NULL,
  hue.colors = c("#2E22EA", "#9E3DFB", "#F86BE2", "#FCCE7B", "#C4E416", "#4BBA0F",
    "#447D87", "#2C24E9"),
  hue.n = 500,
  plot.legend = FALSE
)
}
\arguments{
\item{sce.o}{A \linkS4class{SingleCellExperiment} contains the embbing to be plotted against.}

\item{color_by}{The name of variable in \code{colData(sce.o)} to be used to show colors. Default: "tricyclePosition"}

\item{facet_by}{The name of variable in \code{colData(sce.o)} to be used to facet scatter plots. If used, the function will return a list of ggplot objects. If NULL, no faceted panels will be returned. Default: NULL}

\item{dimred}{The name or index of reducedDims in  \linkS4class{SingleCellExperiment} (\code{\link[SingleCellExperiment]{reducedDims}}). Default: 1}

\item{dim}{The indices of \code{dimred} to be plotted. At the moment, it has to be two integers.   Default: 1:2}

\item{fig.title}{The title of the figure. Default: NULL}

\item{point.size}{The size of the point in scatter plot used by \code{\link[scattermore]{geom_scattermore}}. Default: 2.1}

\item{point.alpha}{The alpha value (transparency) of the point in scatter plot used by \code{\link[scattermore]{geom_scattermore}}. Default: 0.6}

\item{x_lab}{Title of x-axis. If not given, the colname of \code{dimred} will be used. Default: NULL}

\item{y_lab}{Title of y-axis. If not given, the colname of \code{dimred} will be used. Default: NULL}

\item{hue.colors}{The string vector gives the cyclic colors. The first color should look very similar to the last one.
Default: c("#2E22EA", "#9E3DFB", "#F86BE2", "#FCCE7B", "#C4E416", "#4BBA0F", "#447D87", "#2C24E9")}

\item{hue.n}{The number of breaks of color scheme. Default: 500}

\item{plot.legend}{Whether the legend should be plotted with the scatter plot. We recommend not to use this legend but use the cyclic legend produced by \code{\link{circle_scale_legend}} instead. Default: FALSE}
}
\value{
A ggplot object or a list of ggplot objects.
If \code{facet_by} is not assigned, a single ggplot plot of the scatter plot will be return,
Otherwise, apart from the first scatter plot showing all cells together, other faceted scatter plots will also be given in the list.
}
\description{
Generate scat plot of embedding with cyclic cell cycle position or other cyclic variables
}
\details{
This function help users plot embedding scater plot colored by cyclic variables, such as cell cycle position, which is bound between 0 - 2pi.
It will take a \linkS4class{SingleCellExperiment} object as input, and plot out its \code{dimred} such as PCA, UMAP, and etc with a cyclic color scheme.
}
\examples{
data(neurosphere_example, package = "tricycle")
neurosphere_example <- estimate_cycle_position(neurosphere_example)
plot_emb_circle_scale(neurosphere_example, point.size = 3.1, point.alpha = 0.8)
}
\author{
Shijie C. Zheng
}
