% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_emb_circle_scale.R
\name{circle_scale_legend}
\alias{circle_scale_legend}
\title{Get the cyclic legend}
\usage{
circle_scale_legend(hue.colors = c("#2E22EA", "#9E3DFB", "#F86BE2", "#FCCE7B", "#C4E416", "#4BBA0F", "#447D87", "#2C24E9"),
 hue.n = 500, alpha = 0.6, y.inner = 1.5, y.outer = 3, y.text = 3.8, ymax = 4.5, text.size = 3, addStageLabel = FALSE, 
 G1.pos = 0, S.pos = 2.2, G2M.pos = 3.9)
}
\arguments{
\item{hue.colors}{The string vector gives the cyclic colors. The first color should look very similar to the last one.
Default: c("#2E22EA", "#9E3DFB", "#F86BE2", "#FCCE7B", "#C4E416", "#4BBA0F", "#447D87", "#2C24E9")}

\item{hue.n}{The number of breaks of color scheme. Default: 500}

\item{alpha}{The alpha value (transparency). Default: 0.6}

\item{y.inner}{The radius of inner circle of the donut. Default: 1.5}

\item{y.outer}{The radius of outer circle of the donut. Default: 3}

\item{y.text}{The radius of text position. Default: 3.8}

\item{ymax}{The value control the border of the legend. Default: 4.5}

\item{text.size}{The size of the text Default: 3}

\item{addStageLabel}{Whether to add approximate discrete stage labels. Default: FALSE}

\item{G1.pos}{Approximate radius value of G1 label position. Default: 0}

\item{S.pos}{Approximate radius value of S label position. Default: 2.2}

\item{G2M.pos}{Approximate radius value of G2M label position. Default: 3.9}
}
\value{
A ggplot object
}
\description{
This function is a helper function to create the cyclic ggplot color legend.
}
\details{
The function will make a donut shape to serve as the cyclic color legend. The arguments should match the argument used in \code{\link{plot_emb_circle_scale}}.
}
\examples{
circle_scale_legend()
}
\author{
Shijie C. Zheng
}
