% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyseTree.R
\name{getTreeResults}
\alias{getTreeResults}
\title{getTreeResults}
\usage{
getTreeResults(testedTree, sort_by = "parent")
}
\arguments{
\item{testedTree}{a ggtree object outputed from testTree()}

\item{sort_by}{whether to sort by p-values testing via proportions to parent or
p-values testing via absolute proportions. Values can can be c(NA, "parent", "all")}
}
\value{
a dataframe with hierarchical tree nodes, corresponding clusters and
corresponding significance testing results
}
\description{
getTreeResults
}
\examples{
library(SingleCellExperiment)
data(COVIDSampleData)

sce <- DeBiasi_COVID_CD8_samp
exprs <- t(assay(sce, "exprs"))
clusters <- colData(sce)$cluster_id
classes <- colData(sce)$condition
samples <- colData(sce)$sample_id

clust_tree <- getClusterTree(exprs,
                             clusters,
                             hierarchy_method="hopach")

tested_tree <- testTree(clust_tree$clust_tree,
                        clusters=clusters,
                        samples=samples,
                        classes=classes,
                        pos_class_name=NULL)

res_df <- getTreeResults(tested_tree)

head(res_df, 10)
}
