% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftByVar.R
\name{shiftByVar}
\alias{shiftByVar}
\title{Calculate new exon co-ordinates}
\usage{
shiftByVar(x, var, alt_col = "ALT", mc.cores = 1, ...)
}
\arguments{
\item{x}{A GenomicRanges object with co-ordinates needing to be recalculated}

\item{var}{A set of variants to be incorporated into a reference genome}

\item{alt_col}{The name of the column with the alternate sequence for each
variant}

\item{mc.cores}{Passed internally to \code{\link[parallel:mclapply]{parallel::mclapply()}}}

\item{...}{Not used}
}
\value{
GRanges object with co-ordinates shifted according the to the provided
variants. The new co-ordinates will be compatible with a variant-modified
genome as produced by \code{\link[=genomogrify]{genomogrify()}} and can be used to extract the
sequences associated with the ranges in the modified reference.
}
\description{
Calcluate new exon co-ordinates after including InDels
}
\details{
Given a set of variants, this will return a set of genomic ranges with
updated co-ordinates able to be applied on a variant modified reference
genome
}
\examples{
# Define a 3nt insertion
var <- GRanges("seq1:5:*", seqlengths = c(seq1=10), REF = "A", ALT = "AGT")
var
# A simple GRanges to shift co-ordinates for
gr <- GRanges("seq1:1-10:+", seqlengths = c(seq1=10), feature = "feature1")
gr
# Create shifted co-ordinates based on the provided variants
new_gr <- shiftByVar(gr, var)
new_gr
## The seqlengths will have been adjusted to account for all variants
seqinfo(new_gr)

}
