% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owl.R
\name{owl}
\alias{owl}
\alias{owl,XStringSet,GRanges-method}
\alias{owl,BSgenome,GRanges-method}
\title{OverWrite Letters in an XStringSet}
\usage{
owl(seq, snps, ...)

\S4method{owl}{XStringSet,GRanges}(seq, snps, alt_col = "ALT", ol_vars = "fail", ...)

\S4method{owl}{BSgenome,GRanges}(seq, snps, alt_col = "ALT", names, ...)
}
\arguments{
\item{seq}{A BSgenome, DNAStringSet, RNAStringSet or other XStringSet.}

\item{snps}{A GRanges object with SNP positions and a column containing
the alternate allele}

\item{...}{Passed to \code{\link[Biostrings:replaceLetterAt]{Biostrings::replaceLetterAt()}}}

\item{alt_col}{Column name in the mcols element of \code{snps} containing the
alternate allele}

\item{ol_vars}{Error handling for any overlapping variants. See
\link{cleanVariants} for possible values and an explanation}

\item{names}{Sequence names to operate on}
}
\value{
An object of the same class as the original object, but with SNPs
inserted at the supplied positions
}
\description{
OverWrite Letters (e.g. SNPs) in an XStringSet
}
\details{
This is a lower-level function called by \code{\link[=transmogrify]{transmogrify()}} and
\code{\link[=genomogrify]{genomogrify()}}, but able to be called by the user if needed

Note that when providing a BSgenome object, this will first be coerced to a
DNAStringSet which can be time consuming.
}
\examples{
seq <- DNAStringSet(c(chr1 = "AAGC"))
snps <- GRanges("chr1:2")
snps$ALT <- "G"
snps
seq
owl(seq, snps)

}
