% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{create_matrix_motif}
\alias{create_matrix_motif}
\title{Creates Transite motif object from position weight matrix}
\usage{
create_matrix_motif(id, rbps, matrix, type, species, src)
}
\arguments{
\item{id}{motif id (character vector of length 1)}

\item{rbps}{character vector of names of RNA-binding proteins associated
with this motif}

\item{matrix}{data frame with four columns (A, C, G, U) and 6 - 15 rows
(positions),
where cell (i, j) contains weight of nucleotide j on position i}

\item{type}{type of motif (e.g., \code{'HITS-CLIP'}, \code{'EMSA'},
\code{'SELEX'}, etc.)}

\item{species}{species where motif was discovered (e.g.,
\code{'Homo sapiens'})}

\item{src}{source of motif (e.g., \code{'RBPDB v1.3.1'})}
}
\value{
object of class \code{RBPMotif}
}
\description{
Takes a position weight matrix (PWM) and meta info and returns an object of
class \code{RBPMotif}.
}
\examples{
custom_motif <- create_matrix_motif(
  "custom_motif", "RBP1",
  transite:::toy_motif_matrix, "HITS-CLIP",
  "Homo sapiens", "user"
)
}
