% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{create_kmer_origin_list}
\alias{create_kmer_origin_list}
\title{Create \emph{k}-mer lists with their original sequences}
\usage{
create_kmer_origin_list(sequences, k)
}
\arguments{
\item{sequences}{character vector of DNA or RNA sequences that
constitute the whole set of sequences being analyzed}

\item{k}{number of characters in \emph{k}-mer}
}
\value{
A list with \emph{k}-mers as the identifier and a vector
of sequences for each \emph{k}-mer that the \emph{k}-mer is found in
}
\description{
Counts occurrences of \emph{k}-mers of length \code{k} in the given
set of sequences. A list of the sequences the \emph{k}-mer originated
from is created and returned. If the \emph{k}-mer does not exist in
any of the sequences, the list is empty for that \emph{k}-mer.
}
\examples{
# define simple sequence sets for foreground and background
sequence_set <- c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
  "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
  "AUAGAC", "AGUUC", "CCAGUAA"
)
kmer_origin_list <- create_kmer_origin_list(sequence_set, k = 6)

}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
