% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{Terms}
\alias{Terms}
\alias{Terms,Transcriptogram-method}
\alias{Terms-method}
\title{Get terms}
\usage{
Terms(object)

\S4method{Terms}{Transcriptogram}(object)
}
\arguments{
\item{object}{An object of class Transcriptogram.}
}
\value{
This method returns the content of the Terms slot of an object of
class Transcriptogram.
}
\description{
Gets the content of the Terms slot of an object of class Transcriptogram.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900, 50)
\dontrun{
transcriptogram <- transcriptogramStep1(transcriptogram, GSE9988, GPL570)
transcriptogram <- transcriptogramStep2(transcriptogram)
levels <- c(rep(FALSE, 3), rep(TRUE, 3))
transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01)
transcriptogram <- clusterEnrichment(transcriptogram, species = "Homo sapiens",
pValue = 0.005)
Terms(transcriptogram)
}

}
\seealso{
\link[transcriptogramer:differentiallyExpressed-method]{differentiallyExpressed},
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{GSE9988},
\link[transcriptogramer]{GPL570},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{HsBPTerms},
\link[transcriptogramer]{association},
\link[transcriptogramer:transcriptogramStep1-method]{transcriptogramStep1},
\link[transcriptogramer:transcriptogramStep2-method]{transcriptogramStep2},
\link[transcriptogramer:clusterEnrichment-method]{clusterEnrichment}
}
\author{
Diego Morais
}
