% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\docType{methods}
\name{estimateBackground}
\alias{estimateBackground}
\alias{estimateBackground,TranscriptionDataSet-method}
\title{estimateBackground}
\usage{
estimateBackground(object, fdr.cutoff = 0.05)

\S4method{estimateBackground}{TranscriptionDataSet}(object, fdr.cutoff = 0.05)
}
\arguments{
\item{object}{A \code{\link{TranscriptionDataSet}} object.}

\item{fdr.cutoff}{\code{Numeric}. False Discovery Rate cutoff value.
Default: 0.05.}
}
\value{
The slots \code{coverageCutoffFdr} and \code{coverageCutoff}
    of the provided \code{TranscriptionDataSet} object will be updated by
    the FDR cutoff value used in the calculations and by the corresponding
    estimated coverage cutoff value, respectively.
}
\description{
Gene expression is a stochastic process, which often results in substantial
expression noise. To obtain a putative set of transcribed regions, it is
necessary to identify those regions that are expressed significantly above
the background level. Using a Poisson-based approach for estimating
the noise distribution from the frequency of the transcribed regions with the
low fragments coverage, \code{\link{estimateBackground}} function returns a
coverage cutoff value for a specific
\href{https://en.wikipedia.org/wiki/False_discovery_rate}{False Discovery Rate (FDR)}.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### Estimate coverage cutoff at different FDR levels
estimateBackground(object = tds, fdr = 0.01)

}
\seealso{
\code{\link{constructTDS}} \code{\link[chipseq]{peakCutoff}}
}
\author{
Armen R. Karapetyan
}
