% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/fitGAM.R
\name{fitGAM}
\alias{fitGAM}
\alias{fitGAM,matrix-method}
\alias{fitGAM,dgCMatrix-method}
\alias{fitGAM,SingleCellExperiment-method}
\title{fitGAM}
\usage{
fitGAM(counts, ...)

\S4method{fitGAM}{matrix}(
  counts,
  sds = NULL,
  pseudotime = NULL,
  cellWeights = NULL,
  conditions = NULL,
  U = NULL,
  genes = seq_len(nrow(counts)),
  weights = NULL,
  offset = NULL,
  nknots = 6,
  verbose = TRUE,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  control = mgcv::gam.control(),
  sce = TRUE,
  family = "nb",
  gcv = FALSE
)

\S4method{fitGAM}{dgCMatrix}(
  counts,
  sds = NULL,
  pseudotime = NULL,
  cellWeights = NULL,
  conditions = NULL,
  U = NULL,
  genes = seq_len(nrow(counts)),
  weights = NULL,
  offset = NULL,
  nknots = 6,
  verbose = TRUE,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  control = mgcv::gam.control(),
  sce = TRUE,
  family = "nb",
  gcv = FALSE
)

\S4method{fitGAM}{SingleCellExperiment}(
  counts,
  U = NULL,
  genes = seq_len(nrow(counts)),
  conditions = NULL,
  weights = NULL,
  offset = NULL,
  nknots = 6,
  verbose = TRUE,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  control = mgcv::gam.control(),
  sce = TRUE,
  family = "nb",
  gcv = FALSE
)
}
\arguments{
\item{counts}{The count matrix of expression values, with genes
in rows and cells in columns. Can be a matrix or a sparse matrix.}

\item{...}{parameters including:}

\item{sds}{an object of class \code{SlingshotDataSet} or
\code{PseudotimeOrdering}, typically obtained after running Slingshot. If
this is provided, \code{pseudotime} and \code{cellWeights} arguments are
derived from this object.}

\item{pseudotime}{A matrix of pseudotime values, each row represents a cell
and each column represents a lineage.}

\item{cellWeights}{A matrix of cell weights defining the probability that a
cell belongs to a particular lineage. Each row represents a cell and each
column represents a lineage. If only a single lineage, provide a matrix with
one column containing all values of 1.}

\item{conditions}{This argument is in beta phase and should be used carefully.
If each lineage consists of multiple conditions, this argument can be used to
specify the conditions. tradeSeq will then fit a condition-specific smoother for
every lineage.}

\item{U}{The design matrix of fixed effects. The design matrix should not
contain an intercept to ensure identifiability.}

\item{genes}{The genes on which to run \code{fitGAM}. Default to all the genes.
If only a subset of the genes is indicated, normalization will be done using
all the genes but the smoothers will be computed only for the subset.}

\item{weights}{A matrix of weights with identical dimensions
as the \code{counts} matrix. Usually a matrix of zero-inflation weights.}

\item{offset}{The offset, on log-scale. If NULL, TMM is used to account for
differences in sequencing depth., see \code{edgeR::calcNormFactors}.
Alternatively, this may also be a vector with length equal to the number of
cells.}

\item{nknots}{Number of knots used to fit the GAM. Defaults to 6. It is
recommended to use the `evaluateK` function to guide in selecting an
appropriate number of knots.}

\item{verbose}{Logical, should progress be printed?}

\item{parallel}{Logical, defaults to FALSE. Set to TRUE if you want to
parallellize the fitting.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{bpparam} in \code{BiocParallel} package for details.}

\item{control}{Variables to control fitting of the GAM, see
\code{gam.control}.}

\item{sce}{Logical: should output be of SingleCellExperiment class? This is
recommended to be TRUE. If \code{sds} argument is specified, it will always
be set to TRUE}

\item{family}{The assumed distribution for the response. Is set to \code{"nb"}
by default.}

\item{gcv}{(In development). Logical, should a GCV score also be returned?}
}
\value{
If \code{sce=FALSE}, returns a list of length equal to the number of genes
 (number of rows of \code{counts}). Each element of the list is either a
  \code{\link{gamObject}} if the fiting procedure converged, or an error
   message.
If \code{sce=TRUE}, returns a \code{singleCellExperiment} object with
the \code{tradeSeq} results stored in the \code{rowData},
\code{colData} and \code{metadata}.
}
\description{
This fits the NB-GAM model as described in
Van den Berge et al.[2019].
There are two ways to provide the required input in \code{fitGAM}.
See Details and the vignette.
}
\details{
\code{fitGAM} supports four different ways to input the required objects:
\itemize{
\item{"Count matrix, matrix of pseudotime and matrix of cellWeights."}{
Input count matrix using \code{counts} argument and
pseudotimes and cellWeights as a matrix, with number of rows equal to
number of cells, and number of columns equal to number of lineages.}
\item{"Count matrix and Slingshot input."}{Input count matrix using
\code{counts} argument and Slingshot object using \code{sds} argument.}
\item{"SingleCellExperiment Object after running slingshot on the object."}{
Input SingleCellExperiment Object using \code{counts} argument.}
\item{"CellDataSet object after running the \code{orderCells} function."}{
Input CellDataSet Object using \code{counts} argument.}}
}
\examples{
set.seed(8)
data(crv, package="tradeSeq")
data(countMatrix, package="tradeSeq")
sceGAM <- fitGAM(counts = as.matrix(countMatrix),
                  sds = crv,
                  nknots = 5)
}
