% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterExpressionPatterns.R
\name{clusterExpressionPatterns}
\alias{clusterExpressionPatterns}
\alias{clusterExpressionPatterns,SingleCellExperiment-method}
\alias{clusterExpressionPatterns,list-method}
\title{Cluster gene expression patterns.}
\usage{
\S4method{clusterExpressionPatterns}{SingleCellExperiment}(
  models,
  nPoints,
  genes,
  reduceMethod = "PCA",
  nReducedDims = 10,
  minSizes = 6,
  ncores = 1,
  random.seed = 176201,
  verbose = TRUE,
  ...
)

\S4method{clusterExpressionPatterns}{list}(
  models,
  nPoints,
  genes,
  reduceMethod = "PCA",
  nReducedDims = 10,
  minSizes = 6,
  ncores = 1,
  random.seed = 176201,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{models}{The fitted GAMs, typically the output from
\code{\link{fitGAM}}.}

\item{nPoints}{The number of points to use for clustering the expression
patterns.}

\item{genes}{A numerical or character vector specifying the genes from
\code{models} that should be clustered.}

\item{reduceMethod}{Dimensionality reduction method used before running the
clustering methods. Passed to \code{\link[clusterExperiment]{RSEC}}.
Defaults to PCA.}

\item{nReducedDims}{Number of dimensions kept after \code{reduceMethod}.
Passed to \code{\link[clusterExperiment]{RSEC}}.}

\item{minSizes}{Minimum size of clusters.
Passed to \code{\link[clusterExperiment]{RSEC}}.}

\item{ncores}{Number of cores to use. Passed to
\code{\link[clusterExperiment]{RSEC}}}

\item{random.seed}{Passed to \code{\link[clusterExperiment]{RSEC}}}

\item{verbose}{Passed to \code{\link[clusterExperiment]{RSEC}}}

\item{...}{Additional arguments to be passed to
\code{\link[clusterExperiment]{RSEC}}.}
}
\value{
A list containing the scaled fitted values \code{yhatScaled}(for
 plotting) and a \code{clusterExperiment} object, containing the
 clustering results.
}
\description{
Cluster genes in clusters that have similar expression patterns
along all lineages in the trajectory. By default, this function uses the
\code{clusterExperiment} package to do the clustering. If another clustering
method is of interest, one can extract fitted values to use for clustering,
see details in the vignette.
}
\details{
This method adopts the \code{\link[clusterExperiment]{RSEC}}
function from the clusterExperiment package to perform consensus clustering.
}
\examples{
\dontrun{
data(gamList, package = "tradeSeq")
clusterExpressionPatterns(models = gamList, nPoints = 200, genes = seq_len(11),
                          verbose = FALSE)
}
}
