% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{runUMAP}
\alias{runUMAP}
\title{Perform UMAP}
\usage{
runUMAP(object, genes = NA, matrix = "auto", ...)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{genes}{\code{NA} or a vector of character. Perform UMAP on sections if it is \code{NA}, or on given genes if it is a vector of gene names.}

\item{matrix}{Character, must be one of \code{"auto"}, \code{"count"}, \code{"normalized"}, or \code{"scaled"}. If \code{"auto"}, normalized matrix is used for sections and scaled matrix is used for genes.}

\item{...}{Other parameters passed to \code{umap}.}
}
\value{
A \code{SummarizedExperiment} object. The UMAP embeddings are saved in slot \code{meta} if UMAP is performed on sections, or saved in slot \code{gene_embedding} if UMAP is performed on genes.
}
\description{
Perform UMAP on sections or genes in a \code{SummarizedExperiment} object for dimensionality reduction.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)

# Perform UMAP on sections.
zh <- runUMAP(zh)

# Perform UMAP on some genes.
zh <- runUMAP(zh, genes=rownames(zh)[1:100])
}
\seealso{
\code{\link[umap]{umap}} for performing UMAP on a matrix.
}
