% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{kmeansClust}
\alias{kmeansClust}
\title{K-Means clustering across sections}
\usage{
kmeansClust(object, centers, matrix = "normalized", ...)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{centers}{Integer, number of clusters, namely \emph{k}.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{...}{other parameters passed to \code{kmeans}.}
}
\value{
A \code{SummarizedExperiment} object. The obtained cluster labels are saved in slot \code{meta}.
}
\description{
Performs K-Means clustering across sections in a \code{SummarizedExperiment} object.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
zh <- kmeansClust(zh, 3)

# Use scaled read counts to calculate distance
zh <- scaleTomo(zh)
zh <- kmeansClust(zh, 3, matrix="scaled")
}
\seealso{
\code{\link[stats]{kmeans}} for performing K-Means clustering on a matrix.
}
