% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pca.R
\name{run_pca}
\alias{run_pca}
\title{Perform Principal Component Analysis (PCA)}
\usage{
run_pca(
  exposomicset,
  log_trans_exp = FALSE,
  log_trans_omics = TRUE,
  action = "add"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing omics
and exposure data.}

\item{log_trans_exp}{A boolean value specifying whether to log2
transform the exposure data}

\item{log_trans_omics}{a boolean value specifying whether to log2
transform the omics data}

\item{action}{A character string specifying whether to store
(\code{"add"}) or return (\code{"get"}) the results. Default is \code{"add"}.}
}
\value{
If \code{action = "add"}, the function returns the input
\code{MultiAssayExperiment} with:
\itemize{
\item \strong{PC scores} added as columns in \code{colData(exposomicset)}, and
\item \strong{PCA objects} stored under
\code{metadata(exposomicset)$quality_control$pca}.
}

If \code{action = "get"}, the function returns a list containing:
\item{pca_df}{A tibble of the transformed input data.}
\item{pca_feature}{A \code{prcomp} object containing PCA results for features.}
\item{pca_sample}{A \code{prcomp} object containing PCA results for samples.}
\item{outliers}{A character vector of detected sample outliers.}
}
\description{
Runs PCA on the feature and sample spaces of a \code{MultiAssayExperiment} object,
identifying outliers based on Mahalanobis distance.
}
\details{
This function:
\itemize{
\item Identifies \strong{common samples} across all assays and exposure data.
\item Performs \strong{PCA on features} (transformed and standardized).
\item Performs \strong{PCA on samples} and computes Mahalanobis distance to
detect outliers.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run pca
mae <- mae |>
    run_pca()

}
