% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Volcano Plot of Differential Abundance}
\usage{
plot_volcano(
  exposomicset,
  pval_col = "adj.P.Val",
  pval_thresh = 0.05,
  logFC_col = "logFC",
  logFC_thresh = log2(1.5),
  plot_n_sig = TRUE,
  top_n_label = NULL,
  features_to_label = NULL,
  feature_col = "feature",
  xlab = expression(Log[2] * "FC"),
  ylab = expression(-Log[10] * "P"),
  title = "Volcano Plot of Differential Abundance",
  nrow = 2
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing differential
abundance results in \code{metadata(exposomicset)$differential_abundance}.}

\item{pval_col}{A character string specifying the column containing p-values.
Default is \code{"adj.P.Val"}.}

\item{pval_thresh}{A numeric threshold for significance. Features with
p-values below this are considered significant. Default is \code{0.05}.}

\item{logFC_col}{A character string specifying the column for
log fold changes. Default is \code{"logFC"}.}

\item{logFC_thresh}{A numeric threshold for absolute
log fold change significance. Default is \code{log2(1.5)}.}

\item{plot_n_sig}{Logical; if \code{TRUE}, appends the number of
significant features to facet titles. Default is \code{TRUE}.}

\item{top_n_label}{Optional integer. If provided, the top \code{n}
most significant features per assay will be labeled on the plot.}

\item{features_to_label}{Optional character vector.
Specific features to label regardless of significance.}

\item{feature_col}{A character string naming the feature ID
column to use for labeling. Default is \code{"feature"}.}

\item{xlab}{Label for the x-axis. Default is \code{expression(Log[2]*"FC")}.}

\item{ylab}{Label for the y-axis. Default is \code{expression(-Log[10]*"P")}.}

\item{title}{Plot title. Default is
\code{"Volcano Plot of Differential Abundance"}.}

\item{nrow}{Number of rows in the \code{facet_wrap()} layout.
Default is \code{2}.}
}
\value{
A \code{ggplot2} object representing the volcano plot.
}
\description{
Generates a \strong{volcano plot} to visualize differential abundance results
across one or more omics layers.
}
\details{
The function:
\itemize{
\item Extracts differential abundance results from
\code{metadata(exposomicset)$differential_abundance}.
\item Assigns each feature a direction of change:
\strong{Upregulated}, \strong{Downregulated}, or \strong{Not-Significant}.
\item Uses \code{logFC_thresh} and \code{pval_thresh} to define thresholds.
\item Adds dashed lines to indicate cutoffs for fold change and significance.
\item Uses \code{facet_wrap()} to display each assay (\code{exp_name}) separately.
\item Optionally labels the most significant features or user-defined ones.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# perform differential abundance analysis
mae <- run_differential_abundance(
    exposomicset = mae,
    formula = ~ smoker + sex,
    abundance_col = "counts",
    method = "limma_voom",
    action = "add"
)

# create the volcano plot
volcano_p <- mae |>
    plot_volcano()

}
