% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sample_clusters.R
\name{plot_sample_clusters}
\alias{plot_sample_clusters}
\title{Plot Sample Clusters}
\usage{
plot_sample_clusters(exposomicset, exposure_cols = NULL)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing sample
clustering results
in \code{metadata(exposomicset)$sample_clustering}.}

\item{exposure_cols}{A character vector specifying columns from \code{colData}
to include
in the summary. Default is \code{NULL}, which includes all available columns.}
}
\value{
A \code{ComplexHeatmap} plot displaying sample clustering results.
}
\description{
Generates a heatmap of sample clustering results and
summarizes sample group assignments.
}
\details{
This function:
\itemize{
\item Extracts sample cluster assignments from
\code{metadata(exposomicset)$sample_clustering}.
\item Merges cluster labels with \code{colData(exposomicset)}.
\item Plots the heatmap stored in
\code{metadata(exposomicset)$sample_clustering$heatmap}.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 30,
    return_mae = TRUE
)

# determine sample clusters
mae <- run_cluster_samples(
    exposomicset = mae,
    exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi"),
    clustering_approach = "diana"
)

# plot sample clusters
sample_cluster_p <- mae |>
    plot_sample_clusters(
        exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi")
    )

}
