% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_manhattan.R
\name{plot_manhattan}
\alias{plot_manhattan}
\title{Plot a Manhattan-style ExWAS summary across omics categories}
\usage{
plot_manhattan(
  exposomicset,
  pval_thresh = 0.05,
  feature_col = "term",
  alpha = 0.5,
  min_per_cat = 1,
  vars_to_label = NULL,
  sig_color = "magenta2",
  non_sig_cols = c("grey25", "grey75"),
  pval_thresh_line_col = "grey25",
  panel_sizes = c(1, 1, 1, 1, 1),
  linetype = "dashed",
  facet_cols = NULL,
  label_size = 3.5,
  facet_angle = 90,
  facet_text_face = "bold.italic"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object that has
already been processed by \code{associate_all_outcome()}.}

\item{pval_thresh}{Numeric threshold for significance (default = 0.05).}

\item{feature_col}{A character string indicating the column name to use
for feature labeling and highlighting (e.g., \code{"term"} or \code{"feature"}).
Default is \code{"term"}.}

\item{alpha}{Transparency applied to facet strip colors (default = 0.5).}

\item{min_per_cat}{Minimum number of features per category to be shown
(default = 1).}

\item{vars_to_label}{Optional character vector of variable names to label
explicitly, matched against the \code{feature_col} column.}

\item{sig_color}{Color used for significant points (default = \code{"magenta2"}).}

\item{non_sig_cols}{Character vector of alternating colors for
non-significant points (default = \code{c("grey25", "grey75")}).}

\item{pval_thresh_line_col}{Color of the horizontal significance
threshold line (default = \code{"grey25"}).}

\item{panel_sizes}{Numeric vector passed to \code{ggh4x::force_panelsizes()}
to control panel widths (default = \code{c(1,1,1,1,1)}).}

\item{linetype}{Line type for the horizontal threshold (default = \code{"dashed"}).}

\item{facet_cols}{Optional vector of colors to use for
facet strip backgrounds.}

\item{label_size}{Numeric size of the feature label text (default = 3.5).}

\item{facet_angle}{Angle (in degrees) for strip text rotation (default = 90).}

\item{facet_text_face}{Font face for facet strip labels
(default = \code{"bold.italic"}).}
}
\value{
A \code{ggplot} object showing the Manhattan-style faceted plot.
}
\description{
This function generates a multi-faceted Manhattan plot from the results of
\code{associate_all_outcome()}, visualizing the significance of associations
across omics features, grouped by category. Significant features can be
highlighted and labeled, and strip backgrounds can be colored per facet.
}
\details{
\itemize{
\item This function expects \code{associate_all_outcome()} to have been run first.
\item Facets represent omics categories, and points represent features.
\item Points below the significance threshold are colored using \code{non_sig_cols},
while significant ones are colored with \code{sig_color} and optionally labeled.
\item Uses \code{ggrepel} to avoid overlapping labels and \code{ggh4x} for
enhanced faceting.
\item The \code{feature_col} argument allows customization of which column is used
to label or identify features, enabling compatibility with different
result formats.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run association tests
mae <- mae |>
    run_association(
        source = "omics",
        top_n = 20,
        feature_set = c("exposure_pm25", "exposure_no2"),
        outcome = "smoker",
        covariates = c("age"),
        family = "binomial"
    )

# create the manhattan plot
manhattan_p <- mae |>
    plot_manhattan(feature_col = "term")

}
