% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_exposures.R
\name{plot_exposures}
\alias{plot_exposures}
\title{Plot Exposure Distributions by Category or Group}
\usage{
plot_exposures(
  exposomicset,
  exposure_cat = "all",
  exposure_cols = NULL,
  group_by = NULL,
  plot_type = "boxplot",
  alpha = 0.3,
  panel_sizes = rep(1, 100),
  title = "Exposure Levels by Category",
  xlab = "",
  ylab = "",
  facet_cols = NULL,
  group_cols = NULL,
  box_width = 0.1,
  fill_lab = ""
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing exposure data.}

\item{exposure_cat}{A character string or vector specifying exposure
category names (from \code{codebook$category}) to include.
Use \code{"all"} to include all exposures.}

\item{exposure_cols}{Optional character vector specifying exact
exposure variables to plot.}

\item{group_by}{A string specifying the column in \code{colData(exposomicset)}
used to fill the plot (e.g., \code{"sex"}). Defaults to \code{NULL}, in which case
exposures are colored by \code{category}.}

\item{plot_type}{Type of plot: \code{"boxplot"} (default) or \code{"ridge"}.}

\item{alpha}{Transparency level for background facet color strips.
Default is \code{0.5}.}

\item{panel_sizes}{A numeric vector passed to \code{ggh4x::force_panelsizes()}
for controlling facet widths or heights.}

\item{title}{Plot title. Default is \code{"Exposure Levels by Category"}.}

\item{xlab}{X-axis label. Default is an empty string.}

\item{ylab}{Y-axis label. Default is an empty string.}

\item{facet_cols}{Optional vector of colors to use as background for
facet categories. If \code{NULL}, a default palette is used.}

\item{group_cols}{Optional named vector of colors for \code{group_by} levels.
If \code{NULL}, a default palette is used.}

\item{box_width}{A numeric value specifying the width of the boxplots.
Only used when \code{plot_type = "boxplot"}. Default is \code{0.1}.}

\item{fill_lab}{Legend title for the fill aesthetic
(e.g., \code{"Sex"} or \code{"Exposure Group"}). Default is \code{""}.}
}
\value{
A \code{ggplot2} object showing exposure distributions,
optionally grouped.
}
\description{
Visualizes exposure variable distributions using \strong{boxplots}
or \strong{ridge plots}.
}
\details{
This function:
\itemize{
\item Filters exposure data based on category or selected columns.
\item Merges variable metadata from \code{metadata(exposomicset)$codebook}.
\item Supports either \strong{boxplot} (vertical distributions per variable)
or \strong{ridgeplot} (horizontal density plots per variable).
\item If \code{group_by} is specified, that variable defines the plot fill color;
otherwise, the fill is based on exposure \code{category}.
\item Facets by \code{category} using \code{ggh4x::facet_grid2()}
with color-coded strip backgrounds.
\item The \code{box_width} argument controls the width of the boxplots when
\code{plot_type = "boxplot"}.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# plot exposure data
exposure_plot <- mae |>
    plot_exposures(
        exposure_cols = c("exposure_pm25", "exposure_no2"),
        box_width = 0.2
    )

}
