% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment.R
\name{plot_enrichment}
\alias{plot_enrichment}
\title{Plot Enrichment Results from exposomicset}
\usage{
plot_enrichment(
  exposomicset,
  feature_type = c("degs", "degs_robust", "omics", "factor_features", "degs_cor",
    "omics_cor", "factor_features_cor"),
  plot_type = c("dotplot", "cnet", "network", "heatmap", "summary"),
  top_n = 5,
  n_per_group = 5,
  add_top_genes = TRUE,
  top_n_genes = 5,
  heatmap_fill = TRUE,
  logfc_thresh = log2(1),
  pval_col = "P.Value",
  pval_thresh = 0.05,
  score_metric = "stability_score",
  score_thresh = NULL,
  overlap_thresh = 0.2,
  node_radius = 0.2,
  pie_colors = NULL,
  label_top_n = NULL,
  label_colour = "black",
  net_facet_by = NULL,
  max_terms = 30,
  node_size = 1,
  term_node_correction = 0.2,
  gene_node_correction = 3,
  go_groups = NULL,
  layout_algo = "fr",
  edge_alpha = 0.3,
  label_size = 3,
  feature_col = "feature",
  logfc_col = "logFC"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object with enrichment results
added via \code{run_enrichment()}.}

\item{feature_type}{Character; one of \code{"degs"}, \code{"degs_robust"},
\code{"omics"}, \code{"factor_features"},
\code{"degs_cor"}, \code{"omics_cor"}, or \code{"factor_features_cor"}.
Defines which enrichment results to use.}

\item{plot_type}{Type of plot to generate. One of \code{"dotplot"},
\code{"cnet"}, \code{"network"}, \code{"heatmap"}, or \code{"summary"}.}

\item{top_n}{Integer; number of top \code{go_group}s to include
(used in \code{"dotplot"}). Default is \code{5}.}

\item{n_per_group}{Integer; number of terms per group to plot
(used in \code{"dotplot"}). Default is \code{5}.}

\item{add_top_genes}{Logical; if \code{TRUE}, appends top shared genes to
dotplot facets. Default is \code{TRUE}.}

\item{top_n_genes}{Integer; number of top genes to show in each group
(used in \code{"dotplot"}). Default is \code{5}.}

\item{heatmap_fill}{Logical; whether to fill tiles by logFC in the heatmap.
Default is \code{TRUE}.}

\item{logfc_thresh}{Numeric; log2 fold change threshold for filtering
(heatmap only). Default is \code{log2(1)}.}

\item{pval_col}{Column name of the p-value used for filtering in \code{"degs"}
heatmap. Default is \code{"P.Value"}.}

\item{pval_thresh}{Threshold for \code{pval_col} (heatmap only).
Default is \code{0.05}.}

\item{score_metric}{Column for stability score
(used in \code{"degs_robust"} heatmap). Default is \code{"stability_score"}.}

\item{score_thresh}{Numeric; threshold for \code{score_metric}
(heatmap only). Default is \code{NULL}.}

\item{overlap_thresh}{Numeric; Jaccard threshold for edges in
the network plot. Default is \code{0.2}.}

\item{node_radius}{Numeric; node size in network plot. Default is \code{0.2}.}

\item{pie_colors}{Optional named vector of colors for pie charts
(network and cnet).}

\item{label_top_n}{Integer; number of top nodes to label in network.
Default is \code{NULL}.}

\item{label_colour}{Color of node labels in network. Default is \code{"black"}.}

\item{net_facet_by}{Column used to facet the network plot
(e.g., \code{"category"}). Default is \code{NULL}.}

\item{max_terms}{Integer; max number of terms to include in the cnet plot.
Default is \code{30}.}

\item{node_size}{Numeric; base node size for cnet plot. Default is \code{1}.}

\item{term_node_correction}{Scaling factor for term nodes in cnet plot.
Default is \code{0.2}.}

\item{gene_node_correction}{Scaling factor for gene nodes in cnet plot.
Default is \code{3}.}

\item{go_groups}{Optional character vector of GO group names to subset
enrichment results (all plots).}

\item{layout_algo}{Graph layout algorithm to use in \code{"network"} and \code{"cnet"}
plots. Default is \code{"fr"}.}

\item{edge_alpha}{Transparency of network/cnet plot edges.
Default is \code{0.3}.}

\item{label_size}{Font size for labels in network and cnet plots.
Default is \code{3}.}

\item{feature_col}{Column name used to join gene-level metadata.
Default is \code{"feature"}.}

\item{logfc_col}{Column name used for log2 fold change values.
Default is \code{"logFC"}.}
}
\value{
A \code{ggplot} or \code{patchwork} object corresponding to the
requested plot type.
}
\description{
Visualize enrichment results stored in a \code{MultiAssayExperiment} object.
Supports dotplots, heatmaps, cnetplots, networks,
and multi-panel summary plots.
}
\details{
This function visualizes results from \code{run_enrichment()}
using one of several plot types:
\itemize{
\item \code{"dotplot"}: Enrichment terms grouped by GO group, colored by
significance.
\item \code{"heatmap"}: Term - gene matrix with optional logFC fill and
shared gene highlighting.
\item \code{"network"}: Graph of term overlap based on shared genes,
faceted by metadata if desired.
\item \code{"cnet"}: Gene - term bipartite graph with gene logFC values
and term pie slices.
\item \code{"summary"}: Multi-panel figure with GO group ridgeplots,
gene counts, and Venn diagram.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 30,
    return_mae = TRUE
)

# perform differential abundance analysis
mae <- run_differential_abundance(
    exposomicset = mae,
    formula = ~ smoker + sex,
    abundance_col = "counts",
    method = "limma_voom",
    action = "add"
)

# perform enrichment analysis
mae <- run_enrichment(
    exposomicset = mae,
    feature_type = "degs",
    feature_col = "symbol",
    species = "goa_human",
    deg_logfc_threshold = log2(1),
    deg_pval_col = "P.Value",
    deg_pval_threshold = 0.2,
    action = "add"
)

# create an enrichment plot
enr_plot <- plot_enrichment(
    exposomicset = mae,
    feature_type = "degs",
    plot_type = "network"
)

}
