% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_results.R
\name{extract_results}
\alias{extract_results}
\title{Extract Results from \code{MultiAssayExperiment} Metadata}
\usage{
extract_results(
  exposomicset,
  result = c("codebook", "quality_control", "correlation", "association",
    "differential_analysis", "multiomics_integration", "network", "enrichment")
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object.}

\item{result}{A character string indicating which result to
extract from metadata. Must be one of:
\code{"codebook"}, \code{"quality_control"}, \code{"correlation"}, \code{"association"},
\code{"differential_analysis"}, \code{"multiomics_integration"}, \code{"network"},
or \code{"enrichment"}.}
}
\value{
The corresponding result object stored in \code{metadata(exposomicset)},
or \code{NULL} if not present.
}
\description{
Retrieves a specific analysis result
from the metadata slot of a \code{MultiAssayExperiment} object.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# extract results
res <- extract_results(
    exposomicset = mae,
    result = "codebook"
)

}
