% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_dimensions.R
\docType{methods}
\name{rotate_dimensions}
\alias{rotate_dimensions}
\alias{rotate_dimensions,SummarizedExperiment-method}
\alias{rotate_dimensions,RangedSummarizedExperiment-method}
\title{Rotate two dimensions (e.g., principal components) of an arbitrary angle}
\usage{
rotate_dimensions(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element = NULL,
  of_samples = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL
)

\S4method{rotate_dimensions}{SummarizedExperiment}(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element = NULL,
  of_samples = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL
)

\S4method{rotate_dimensions}{RangedSummarizedExperiment}(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element = NULL,
  of_samples = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL
)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}

\item{dimension_1_column}{A character string. The column of the dimension 1}

\item{dimension_2_column}{A character string. The column of the dimension 2}

\item{rotation_degrees}{A real number between 0 and 360}

\item{.element}{The name of the element column (normally samples).}

\item{of_samples}{A boolean. In case the input is a tidybulk object, it indicates Whether the element column will be sample or transcript column}

\item{dimension_1_column_rotated}{A character string. The column of the rotated dimension 1 (optional)}

\item{dimension_2_column_rotated}{A character string. The column of the rotated dimension 2 (optional)}
}
\value{
A tbl object with additional columns for the reduced dimensions. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.

A `SummarizedExperiment` object

A `SummarizedExperiment` object
}
\description{
rotate_dimensions() takes as input a `tbl` formatted as | <DIMENSION 1> | <DIMENSION 2> | <...> | and calculates the rotated dimensional space of the transcript abundance.
}
\details{
`r lifecycle::badge("maturing")`

This function to rotate two dimensions such as the reduced dimensions.

Underlying custom method:
rotation = function(m, d) {
  r = d * pi / 180
  ((bind_rows(
    c(`1` = cos(r), `2` = -sin(r)),
    c(`1` = sin(r), `2` = cos(r))
  ) |> as_matrix()) %*% m)
}
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex



counts.MDS =
 airway |>
 identify_abundant() |>
 reduce_dimensions( method="MDS", .dims = 3)

counts.MDS.rotated =  rotate_dimensions(counts.MDS, `Dim1`, `Dim2`, rotation_degrees = 45, .element = sample)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7
}
