% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_identify_abundant.R
\docType{methods}
\name{identify_abundant}
\alias{identify_abundant}
\alias{identify_abundant,SummarizedExperiment-method}
\alias{identify_abundant,RangedSummarizedExperiment-method}
\title{Identify abundant transcripts/genes}
\usage{
identify_abundant(
  .data,
  abundance = assayNames(.data)[1],
  design = NULL,
  formula_design = NULL,
  minimum_counts = 10,
  minimum_proportion = 0.7,
  minimum_count_per_million = NULL,
  factor_of_interest = NULL,
  ...,
  .abundance = NULL
)

\S4method{identify_abundant}{SummarizedExperiment}(
  .data,
  abundance = assayNames(.data)[1],
  design = NULL,
  formula_design = NULL,
  minimum_counts = 10,
  minimum_proportion = 0.7,
  minimum_count_per_million = NULL,
  factor_of_interest = NULL,
  ...,
  .abundance = NULL
)

\S4method{identify_abundant}{RangedSummarizedExperiment}(
  .data,
  abundance = assayNames(.data)[1],
  design = NULL,
  formula_design = NULL,
  minimum_counts = 10,
  minimum_proportion = 0.7,
  minimum_count_per_million = NULL,
  factor_of_interest = NULL,
  ...,
  .abundance = NULL
)
}
\arguments{
\item{.data}{A `tbl` or `SummarizedExperiment` object containing transcript/gene abundance data}

\item{abundance}{The name of the transcript/gene abundance column (character, preferred)}

\item{design}{A design matrix for more complex experimental designs. If provided, this is passed to filterByExpr instead of factor_of_interest.}

\item{formula_design}{...}

\item{minimum_counts}{...}

\item{minimum_proportion}{...}

\item{minimum_count_per_million}{Minimum CPM cutoff to use for filtering (passed to CPM.Cutoff in filterByExpr). If provided, this will override the minimum_counts parameter. Default is NULL (uses edgeR default).}

\item{factor_of_interest}{The name of the column containing groups/conditions for filtering. 
Used by edgeR's filterByExpr to define sample groups. 
\strong{DEPRECATED:} Use 'design' or 'formula_design' instead. This argument will be removed in a future release.}

\item{...}{Further arguments.}

\item{.abundance}{DEPRECATED. The name of the transcript/gene abundance column (symbolic, for backward compatibility)}
}
\value{
Returns the input object with an additional logical column `.abundant` indicating which 
features passed the abundance threshold criteria.

A `SummarizedExperiment` object

A `SummarizedExperiment` object
}
\description{
Identifies transcripts/genes that are consistently expressed above a threshold across samples. 
This function adds a logical column `.abundant` to indicate which features pass the filtering criteria.
}
\details{
`r lifecycle::badge("maturing")`


This function uses edgeR's filterByExpr() function to identify consistently expressed features.
A feature is considered abundant if it has CPM > minimum_counts in at least minimum_proportion 
of samples in at least one experimental group (defined by factor_of_interest or design).
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex


# Basic usage
airway |> identify_abundant()

# With custom thresholds
airway |> identify_abundant(
  minimum_counts = 5,
  minimum_proportion = 0.5
)

# Using a factor of interest
airway |> identify_abundant(factor_of_interest = condition)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7

McCarthy, D. J., Chen, Y., & Smyth, G. K. (2012). Differential expression analysis of 
multifactor RNA-Seq experiments with respect to biological variation. Nucleic Acids Research, 
40(10), 4288-4297. DOI: 10.1093/bioinformatics/btp616
}
