% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{score_regions}
\alias{score_regions}
\title{Calculate region scores}
\usage{
score_regions(peak_score, region_id)
}
\arguments{
\item{peak_score}{A vector of integers}

\item{region_id}{A vector of character}
}
\value{
A vector of numerics
}
\description{
Calculate the region score based on the distance to their assigned peaks.
}
\examples{
library(IRanges)

query <- IRanges(c(1, 4, 9), c(5, 7, 10))
subject <- IRanges(c(2, 2, 10), c(2, 3, 12))
distance <- find_distance(query, subject)
peak_score <- score_peaks(distance, 100000)
region_id <- c('region1', 'region1', 'region2')
region_score <- score_regions(peak_score, region_id)

}
