% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{real_transcripts}
\alias{real_transcripts}
\title{Differential expression of DHT treated LNCaP cell line}
\format{A \code{GRanges}}
\source{
\url{https://github.com/suwangbio/BETA/blob/master/BETA_test_data/
AR_diff_expr.xls}

\url{https://github.com/suwangbio/BETA/blob/master/BETA_1.0.7/BETA/
references/hg19.refseq}
}
\usage{
real_transcripts
}
\description{
The differential expression analysis output of LNCaP cell line treated with
DHT for 16 hours compared to non-treated cells. The REFSEQ transcript
identifiers were used to merge the data.frame with the transcript
coordinates from the hg19 reference genome.
}
\examples{
# load data
data('real_transcripts')

# locate the raw data
system.file('extdata', 'AR_diff_expr.tsv.gz', package = 'target')
system.file('extdata', 'hg19.refseq', package = 'target')

# locate the source code for preparing the data
system.file('extdata', 'make-data.R', package = 'target')
}
\seealso{
\code{\link{real_peaks}}

\code{\link{sim_transcripts}}
}
\keyword{datasets}
