% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsNewtab.R
\name{removeSpsTab}
\alias{removeSpsTab}
\title{Remove a SPS tab}
\usage{
removeSpsTab(
  tab_id = "none",
  force = FALSE,
  app_path = getwd(),
  multiple = FALSE,
  verbose = spsOption("verbose"),
  colorful = spsOption("use_crayon")
)
}
\arguments{
\item{tab_id}{tab ID, string, length 1, supports regular expressions, so
be careful. If more than one tabs are matched, stop by default}

\item{force}{bool, whether to ask for confirmation}

\item{app_path}{app directory}

\item{multiple}{bool, if matched more than one tab, turn this to \emph{TRUE} can
remove more than one tab at a time. Be careful.}

\item{verbose}{bool, follows project setting, but can be overwrite.
\emph{TRUE} will give you more information}

\item{colorful}{bool, whether the message will be colorful?}
}
\value{
remove the tab file and register info in \emph{tabs.csv}
}
\description{
Remove a tab R file and remove from the tabs.csv config file
}
\examples{
spsInit(change_wd = FALSE, overwrite = TRUE)
spsNewTab("vs_new", app_path = glue::glue("SPS_{format(Sys.time(), '\%Y\%m\%d')}"))
removeSpsTab("vs_new", force = TRUE,
             app_path = glue::glue("SPS_{format(Sys.time(), '\%Y\%m\%d')}"))
}
