% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dose_response_model.R
\name{FitDoseResponse}
\alias{FitDoseResponse}
\title{Fitting Single Drug Dose-Response Model}
\usage{
FitDoseResponse(data, Emin = NA, Emax = NA)
}
\arguments{
\item{data}{A data frame. It contains two columns:
\itemize{
  \item \strong{dose} The concentration of drugs added in experiment.
  \item \strong{response} The response (% inhibition) of cell lines to drug
    with different concentrations.
}}

\item{Emin}{A numeric value or \code{NA}. the minimal effect of the drug used
in the 4-parameter log-logistic function to fit the dose-response curve. If
it is not NA, it is fixed the value assigned by the user. Default setting
is \code{NA}.}

\item{Emax}{A numeric or \code{NA}. the maximal effect of the drug used in
the 4-parameter log-logistic function to fit the dose-response curve. If it
is not NA, it is fixed the value assigned by the user. Default setting is
\code{NA}.}
}
\value{
An object of class 'drc'. It contains information of fitted model.
}
\description{
Function \code{FitDoseResponse} fits dose-response model by using
\code{\link[drc]{drm}} function.
}
\details{
Pre-fitting process:
1. Change the 0 value in concentration into 10^-10 to avoide raising error
when taking log.
2. If the variance of "response" values equal to 0, add 10^-10 to the last
"response" value.

Model choice:
First use "L.4" model to fit the raw data. If error or waring occurs, use
"LL.4" model to fit \code{log(raw data)}.
}
\examples{
df <- data.frame(
  response = c(0, 29, 59, 60, 75, 90),
  dose = c(0.00, 9.7656, 39.0626, 156.25, 625, 2500)
)
model <- FitDoseResponse(df)
}
\references{
Seber, G. A. F. and Wild, C. J (1989)
href{https://onlinelibrary.wiley.com/doi/book/10.1002/0471725315}{Nonlinear
Regression, New York}: Wiley \& Sons (p. 330).
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
