% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_crop_fast.R
\name{get_blobs}
\alias{get_blobs}
\title{get_blobs}
\usage{
get_blobs(
  img_orig,
  blob_factor,
  bg_blob_factor,
  offset,
  final_blob_amp,
  brush_size_blob,
  sigma_blob,
  watershed_tol,
  watershed_radius,
  crowded_cells,
  annotation
)
}
\arguments{
\item{img_orig}{Original image}

\item{blob_factor, }{Contrast factor to multiply original image by before
smoothing/smudging}

\item{bg_blob_factor, }{Contrast factor to multiply original image by to take
background. Used prior to thresholding.}

\item{offset, }{Pixel value offset from bg_blob_factor. Used in thresholding
to make blob mask.}

\item{final_blob_amp, }{Contrast factor to multiply smoothed/smudged image.
Used in thresholding to make blob mask.}

\item{brush_size_blob, }{Brush size for smudging the synaptonemal complex channel to make blobs}

\item{sigma_blob, }{Sigma in Gaussian brush for smudging the synaptonemal complex channel to
make blobs}

\item{watershed_tol}{Intensity tolerance for watershed method. Defaults to 0.05.}

\item{watershed_radius}{Radius (ext variable) in watershed method used
in strand channel. Defaults to 1 (small)}

\item{crowded_cells}{TRUE or FALSE, defaults to FALSE. Set to TRUE if you
have many cells in a frame that almost touch}

\item{annotation, }{Choice to output pipeline choices (recommended to knit)
have many cells in a frame that almost touch}
}
\value{
Mask with cell candidates
}
\description{
Makes mask of all objects bright enough to be classified as a cell
cadidate
}
